﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class DailySalesReportDB
    {
        public static DailySalesReport GetItem(Guid ReportID,DateTime ReportDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ReportID", ((ReportID != Guid.Empty && ReportID != null) ? ReportID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ReportDate", ((ReportDate!=null && ReportDate != DateTime.MinValue) ? ReportDate : (object)DBNull.Value)));


            return SQLHelper.RetrieveObject<DailySalesReport>("spGetDailySalesReport", parameters);
        }

        public static List<DailySalesReport> GetList(Guid ReportID,DateTime ReportDate)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ReportID", ((ReportID != Guid.Empty && ReportID != null) ? ReportID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ReportDate", ((ReportDate != null && ReportDate != DateTime.MinValue) ? ReportDate : (object)DBNull.Value)));


            return SQLHelper.RetrieveList<DailySalesReport>("spGetLayouts", parameters);
        }

        public static void Save(DailySalesReport SalesReport)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            if (SalesReport.DailyReportID == Guid.Empty)
            {
                SalesReport.DailyReportID = Guid.NewGuid();
            }
            parameters.Add(new SqlParameter("@ReportID", (SalesReport.DailyReportID != null && SalesReport.DailyReportID != Guid.Empty) ? SalesReport.DailyReportID : (object)DBNull.Value));
            parameters.Add(new SqlParameter("@ReportDate", ((SalesReport.ReportDate != null && SalesReport.ReportDate != DateTime.MinValue) ? SalesReport.ReportDate: (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@CashRegisterBalance", ((SalesReport.CashRegisterBalance!=decimal.MinValue)? SalesReport.CashRegisterBalance:(object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OpeningBalance", ((SalesReport.OpeningBalance!=decimal.MinValue)? SalesReport.OpeningBalance:(object)DBNull.Value)));
            parameters.Add(new SqlParameter("@MoneyIn", ((SalesReport.MoneyIn!=decimal.MinValue)? SalesReport.MoneyIn:(object)DBNull.Value)));
            parameters.Add(new SqlParameter("@MoneyOut", ((SalesReport.MoneyOut!=decimal.MinValue)? SalesReport.MoneyOut:(object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ReconcileAmount", ((SalesReport.ReconcileAmount!=decimal.MinValue)? SalesReport.ReconcileAmount:(object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Remarks", ((!string.IsNullOrEmpty(SalesReport.Remarks))? SalesReport.Remarks:(object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ReportStatus", ((!string.IsNullOrEmpty(SalesReport.ReportStatus)) ? SalesReport.ReportStatus : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@CreatedBy", (SalesReport.CreatedBy != null && SalesReport.CreatedBy != Guid.Empty) ? SalesReport.CreatedBy : (object)DBNull.Value));
            parameters.Add(new SqlParameter("@OpeningRemarks", ((!string.IsNullOrEmpty(SalesReport.OpeningRemarks)) ? SalesReport.OpeningRemarks : (object)DBNull.Value)));

            
            SQLHelper.ExecuteQuery("spAddOrUpdateDailySalesReport", parameters);
        }

        //public static void Delete(Guid TableID)
        //{
        //    List<SqlParameter> parameters = new List<SqlParameter>();
        //    parameters.Add(new SqlParameter("@TableID", ((TableID != Guid.Empty && TableID != null) ? TableID : (object)DBNull.Value)));

        //    SQLHelper.ExecuteQuery("spRemoveLayout", parameters);
        //}

    }
}
